<?php
// get-post.php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

// Database connection
$host = "localhost:3306";
$dbname = "blog";
$username = "root";
$password = "";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    echo json_encode(["success" => false, "error" => "Database connection failed"]);
    exit;
}

if (!isset($_GET["id"]) || !is_numeric($_GET["id"])) {
    echo json_encode(["success" => false, "error" => "Invalid post ID"]);
    exit;
}

$post_id = (int)$_GET["id"];

$stmt = $pdo->prepare("SELECT * FROM blog_posts WHERE id = ? AND status = ?published?");
$stmt->execute([$post_id, "published"]);
$post = $stmt->fetch(PDO::FETCH_ASSOC);

if ($post) {
    echo json_encode([
        "success" => true,
        "id" => $post["id"],
        "title" => $post["title"],
        "content" => $post["content"],
        "excerpt" => $post["excerpt"],
        "featured_image" => $post["featured_image"],
        "published_at" => $post["published_at"],
        "created_at" => $post["created_at"],
        "views" => $post["views"]
    ]);
} else {
    echo json_encode(["success" => false, "error" => "Post not found"]);
}
?>